#ifndef POF_C_API_H_
#define POF_C_API_H_

// #include "POF/User_Parameter.h"
// #include "POF/NN_data.h"
// #include "POF/Indata.h"
// #include "POF/Loss_generator.h"
#include "POF/Gradient_generator.h"
#include "POF/Gradient_estimator.h"
#include "POF/Gradient_generator_fullcal.h"
#include "POF/Gradient_generator_fullcal_par20.h"
#include "POF/Gradient_generator_fullcal_approx.h"
#include "POF/Gradient_generator_fullcal_sample_grad.h"
#include <stdio.h>

extern "C" int POF_init_userparameter(struct User_parameter** p_user_parameter);
extern "C" int POF_print_userparameter(struct User_parameter* user_parameter);
extern "C" int POF_set_userparameter(
	int n_rank,
	double th,
	double beta,
	double min_loss,
	double lambda,
	double xi,
	double context_list[],
	struct User_parameter* user_parameter
);
extern "C" int POF_update_xi(
	double xi,
	struct User_parameter* user_parameter
);
extern "C" int POF_update_min_loss(
	double min_loss,
	struct User_parameter* user_parameter
);
extern "C" int POF_set_w_cnt(
	double w_cnt
);

extern "C" int POF_init_nndata(struct NN_data** p_nndata);
extern "C" int POF_print_nndata(struct NN_data* nn_data);
extern "C" double POF_get_bias(struct NN_data* nn_data);
extern "C" int POF_update_train_nndata(int batch_size, int n_class, double objective_list[], double ccon_w_list[], struct NN_data* nn_data);
extern "C" int POF_update_intest_nndata(int n_internal_test_case, int n_class, int ans_list[], double test_case_ccon_w_list[], struct NN_data* nn_data);
extern "C" int POF_update_nndata(int batch_size, int n_internal_test_case, int n_class, double objective_list[], int ans_list[], double ccon_w_list[], double test_case_ccon_w_list[], struct NN_data* nn_data);

extern "C" int POF_init_indata(struct Indata** p_indata);
extern "C" int POF_print_indata(struct Indata* indata);
extern "C" double POF_get_posterior(struct Indata* indata, int i, int j, int k);
extern "C" int POF_set_bias(int mode, struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata);
extern "C" int POF_update_indata(int mode, struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata);

extern "C" int POF_get_solution(NN_data* nn_data, Indata* indata, User_parameter* user_parameter);
extern "C" double POF_calc_approx_loss(NN_data* nn_data, Indata* indata, User_parameter* user_parameter);

extern "C" int POF_calc_grad_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[]);
extern "C" int POF_estimate_ccon_grad(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[], double ccon_gradient_square_list[], int n_sample);
extern "C" int POF_estimate_grad(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[], double ccon_gradient_square_list[], double test_case_ccon_gradient_list[], double test_case_ccon_gradient_square_list[], int n_sample);
extern "C" int POF_fullcalc_grad_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[]);
extern "C" int POF_fullcalc_grad_ccon_sample_grad(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[], double clip);

extern "C" int POF_calc_grad_test_case_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[]);
extern "C" int POF_estimate_test_case_ccon_grad(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[], double test_case_ccon_gradient_square_list[], int n_sample);
extern "C" int POF_fullcalc_grad_test_case_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[]);
extern "C" int POF_fullcalc_par20_grad_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[]);
extern "C" int POF_fullcalc_par20_grad_test_case_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[]);
extern "C" int POF_fullcalc_approx_grad_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[]);
extern "C" int POF_fullcalc_approx_grad_test_case_ccon(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[]);

extern "C" const char* POF_GetLastError();

#if !defined(__cplusplus) && (!defined(__STDC__) || (__STDC_VERSION__ < 199901L))
/*! \brief Inline specifier no-op in C using standards before C99. */
#define INLINE_FUNCTION
#else
/*! \brief Inline specifier. */
#define INLINE_FUNCTION inline
#endif

#if !defined(__cplusplus) && (!defined(__STDC__) || (__STDC_VERSION__ < 201112L))
/*! \brief Thread local specifier no-op in C using standards before C11. */
#define THREAD_LOCAL
#elif !defined(__cplusplus)
/*! \brief Thread local specifier. */
#define THREAD_LOCAL _Thread_local
#elif defined(_MSC_VER)
/*! \brief Thread local specifier. */
#define THREAD_LOCAL __declspec(thread)
#else
/*! \brief Thread local specifier. */
#define THREAD_LOCAL thread_local
#endif

static char* LastErrorMsg() { static THREAD_LOCAL char err_msg[512] = "Everything is fine"; return err_msg; }

#ifdef _MSC_VER
  #pragma warning(disable : 4996)
#endif

INLINE_FUNCTION void POF_SetLastError(const char* msg) {
    cout<< msg << endl;
#if !defined(__cplusplus) && (!defined(__STDC__) || (__STDC_VERSION__ < 199901L))
  sprintf(LastErrorMsg(), "%s", msg);  /* NOLINT(runtime/printf) */
#else
  const int err_buf_len = 512;
  snprintf(LastErrorMsg(), err_buf_len, "%s", msg);
#endif
}

#endif  /* POF_C_API_H_ */